/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.world.gen;

import com.mojang.serialization.Codec;
import enemeez.simplefarming.block.growable.PlantBlock;
import enemeez.simplefarming.config.GenConfig;
import enemeez.simplefarming.init.ModBlocks;
import enemeez.simplefarming.util.WorldGenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WildPlantFeature
extends Feature<NoFeatureConfig> {
    private List<BlockState> lookup = new ArrayList<BlockState>();

    public WildPlantFeature(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
        this.initList();
    }

    public boolean place(ISeedReader world, ChunkGenerator cg, Random random, BlockPos pos, NoFeatureConfig config) {
        boolean flag;
        String id = world.func_201672_e().func_234923_W_().func_240901_a_().toString();
        boolean bl = flag = ((List)GenConfig.blacklist.get()).contains(id) || !((List)GenConfig.whitelist.get()).contains(id);
        if (random.nextInt((Integer)GenConfig.wild_plant_chance.get()) != 0 || flag) {
            return false;
        }
        BlockState type = this.getRand();
        int rolls = WorldGenHelper.getRolls();
        for (int i = 0; i < rolls; ++i) {
            int offset;
            int initial;
            switch (i) {
                case 0: {
                    initial = WorldGenHelper.getRand();
                    offset = WorldGenHelper.getRand();
                    if (WorldGenHelper.checkConditions((IWorld)world, pos.func_177964_d(initial).func_177985_f(offset))) {
                        this.generatePlant((IWorld)world, pos.func_177964_d(initial).func_177985_f(offset), random, type);
                    }
                }
                case 1: {
                    initial = WorldGenHelper.getRand();
                    offset = WorldGenHelper.getRand();
                    if (WorldGenHelper.checkConditions((IWorld)world, pos.func_177970_e(initial).func_177965_g(offset))) {
                        this.generatePlant((IWorld)world, pos.func_177970_e(initial).func_177965_g(offset), random, type);
                    }
                }
                case 2: {
                    initial = WorldGenHelper.getRand();
                    offset = WorldGenHelper.getRand();
                    if (!WorldGenHelper.checkConditions((IWorld)world, pos.func_177964_d(initial).func_177965_g(offset))) break;
                    this.generatePlant((IWorld)world, pos.func_177964_d(initial).func_177965_g(offset), random, type);
                }
            }
            initial = WorldGenHelper.getRand();
            offset = WorldGenHelper.getRand();
            if (!WorldGenHelper.checkConditions((IWorld)world, pos.func_177970_e(initial).func_177985_f(offset))) continue;
            this.generatePlant((IWorld)world, pos.func_177970_e(initial).func_177985_f(offset), random, type);
        }
        return true;
    }

    public void generatePlant(IWorld world, BlockPos pos, Random random, BlockState state) {
        world.func_180501_a(pos, state, 2);
    }

    private void initList() {
        if (((Boolean)GenConfig.marshmallow_flag.get()).booleanValue()) {
            this.lookup.add((BlockState)ModBlocks.marshmallow.func_176223_P().func_206870_a((Property)PlantBlock.AGE, (Comparable)Integer.valueOf(3)));
        }
        if (((Boolean)GenConfig.quinoa_flag.get()).booleanValue()) {
            this.lookup.add((BlockState)ModBlocks.quinoa.func_176223_P().func_206870_a((Property)PlantBlock.AGE, (Comparable)Integer.valueOf(3)));
        }
        if (((Boolean)GenConfig.cumin_flag.get()).booleanValue()) {
            this.lookup.add((BlockState)ModBlocks.cumin.func_176223_P().func_206870_a((Property)PlantBlock.AGE, (Comparable)Integer.valueOf(3)));
        }
        if (((Boolean)GenConfig.chichory_flag.get()).booleanValue()) {
            this.lookup.add((BlockState)ModBlocks.chicory.func_176223_P().func_206870_a((Property)PlantBlock.AGE, (Comparable)Integer.valueOf(3)));
        }
    }

    private BlockState getRand() {
        return this.lookup.get((int)(Math.random() * (double)this.lookup.size()));
    }
}

